<?php

namespace sms\Yiwansms;
use app\admin\lib\Plugin;

class YiwansmsPlugin extends Plugin {

    // 插件信息
    public $info = array(
        'name'        => 'Yiwansms',    // 插件名（English）
        'title'       => '意玩短信',    // 插件名（Chinese）
        'description' => '意玩短信',    // 插件描述
        'status'      => 1,
        'author'      => '意玩网络',
        'version'     => '1.0.0',
        'help_url'    => 'https://ywly.cc'
    );

    // 插件安装
    public function install() {

        // 导入模板
        $SmsTemplate = [];

        if (file_exists(__DIR__ . '/config/smsTemplate.php')) {
            $SmsTemplate = require __DIR__ . '/config/smsTemplate.php';
        }

        return $SmsTemplate;
    }

    // 插件卸载
    public function uninstall() {
        return true;
    }

    // 后台页面创建模板时可用参数
    public function description() {
        return file_get_contents(__DIR__ . '/description.html');
    }

    // 获取国内模板
    public function getCnTemplate($params) {
        $data['status'] = 'success';
        $data['template']['template_status'] = 2;
        return $data;
    }

    // 创建国内模板
    public function createCnTemplate($params) {
        $data['status'] = 'success';
        $data['template']['template_status'] = 2;
        return $data;
    }

    // 修改国内模板
    public function putCnTemplate($params) {
        $data['status'] = 'success';
        $data['template']['template_status'] = 2;
        return $data;
    }

    // 删除国内模板
    public function deleteCnTemplate($params) {
        $data['status'] = 'success';
        return $data;
    }

    // 发送国内短信
    public function sendCnSms($params) {
        $content = $this->templateParam($params['content'], $params['templateParam']);
        $param['content'] = $this->templateSign($params['config']['sign']).$content;
        $param['mobile'] = trim($params['mobile']);
        $resultTemplate= $this->APIHttpRequestCURL('cn',$param,$params['config']);
        if($resultTemplate['status'] == "success") {
            $data['status'] = "success";
            $data['content'] = $content;
        } else {
            $data['status'] = "error";
            $data['content'] = $content;
            $data['msg'] = $resultTemplate['msg'];
        }
        return $data;
    }

    // 以下函数自定义

    private function templateParam($content,$templateParam){
        foreach ($templateParam as $key => $para) {
            $content = str_replace('@var(' . $key . ')', $para, $content);//模板中的参数替换
        }       
		$content =preg_replace("/@var\(.*?\)/is","",$content);
        return $content;
    }

	private function templateSign($sign){
		$sign = str_replace("【","",$sign);
		$sign = str_replace("】","",$sign);
		$sign = "【".$sign."】";  
        return $sign;
    }

    private function APIHttpRequestCURL($sms_type = "cn",$params,$config) {
        if ($sms_type == "cn") {
            $ApiURL = "https://api.ywly.cc/sms/sendApi.php";
        } else {
            $ApiURL = "https://api.ywly.cc/sms/sendApi.php";
        }
       
        if (!isset($config["key"]) || !$config["key"]) {
            return array(
                'status' => "error",
                'msg'    => '配置错误，密钥不能为空!'
            );
        }

        if (!isset($config["sign"]) || !$config["sign"]) {
            return array(
                'status' => "error",
                'msg'    => '配置错误，签名不能为空!'
            ); 
        }

        if (!isset($params["mobile"]) || !$params["mobile"]) {
            return array(
                'status' => "error",
                'msg'    => '接收手机号码不能为空!'
            );
        }

        $ApiURL = 'https://api.ywly.cc/sms/sendApi.php';
        $queryParams = array(
            'AppKey'    => $config["key"],
            'phone'     => $params["mobile"],
            'content'   => $params["content"]
        );
        $requestUrl = $ApiURL . '?' . http_build_query($queryParams);
        $result = file_get_contents($requestUrl);
        $result = json_decode($result,true);
        if ($result['code'] == 1) {
            return array('status' => "success", 'msg' => $result['msg']);
        } else {
            return array('status' => "error", 'msg' => $result['msg']);
        }
    }

}

?>